/*
 * Decompiled with CFR 0.152.
 */
package emeraldrandomizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PokePalette {
    private final int VARIA = 10;
    private final int VARIABASE = 3;
    private final int LIGHTDARK_CHANCE = 20;
    private final int TOTAL_CHANGE_THRESHOLD = 9;
    private final int LIGHT = 1;
    private final int DARK = 2;
    private final int RAND_LIGHT = 3;
    private final int RAND_DARK = 4;
    private final int EMPTY = 0;
    private ArrayList<int[]> alBaseColors;
    private ArrayList<Integer> alColorList;
    private ArrayList<Integer> alLightDark;
    private int[][] fullPalette;
    private Random rand = new Random();
    private boolean[] colorUsed;
    public final int[][] baseColors = new int[][]{{255, 157, 231}, {203, 149, 253}, {197, 154, 139}, {164, 106, 68}, {201, 101, 111}, {235, 166, 90}, {119, 183, 183}, {113, 165, 251}, {142, 89, 64}, {236, 13, 215}, {36, 255, 36}, {151, 135, 184}, {216, 172, 124}, {168, 162, 119}, {211, 163, 90}, {146, 182, 133}, {108, 120, 140}, {146, 129, 103}, {159, 240, 79}, {149, 173, 63}, {234, 234, 8}, {135, 41, 250}, {66, 68, 138}, {77, 95, 157}, {192, 192, 192}, {228, 135, 31}, {226, 82, 33}, {168, 139, 19}, {236, 23, 103}, {126, 12, 203}, {253, 130, 47}, {205, 10, 10}, {250, 213, 43}, {64, 69, 252}, {10, 170, 170}, {97, 209, 165}, {9, 183, 9}, {78, 145, 49}, {214, 193, 50}, {251, 242, 89}, {32, 251, 251}, {250, 24, 24}, {197, 77, 242}, {206, 96, 159}, {130, 48, 184}, {130, 252, 230}, {196, 208, 210}, {122, 186, 250}, {216, 61, 65}, {140, 53, 53}, {53, 64, 189}, {74, 74, 74}, {9, 9, 187}, {146, 12, 12}};

    public PokePalette() {
        this.alBaseColors = new ArrayList();
        this.alColorList = this.makeColorList();
        this.alLightDark = new ArrayList();
        this.fullPalette = new int[16][3];
        this.makeNewColorUsed();
    }

    public PokePalette(ArrayList<int[]> albc, ArrayList<Integer> alcl, ArrayList<Integer> alld, boolean[] mcu) {
        this.alBaseColors = albc;
        this.alColorList = alcl;
        this.alLightDark = alld;
        this.fullPalette = new int[16][3];
        this.colorUsed = mcu;
    }

    public PokePalette getClone() {
        this.makeNewColorUsed();
        return new PokePalette(this.alBaseColors, this.alColorList, this.alLightDark, this.colorUsed);
    }

    public ArrayList<int[]> getPalette() {
        return this.alBaseColors;
    }

    public ArrayList<Integer> getColorList() {
        return this.alColorList;
    }

    public ArrayList<Integer> getLightDark() {
        return this.alLightDark;
    }

    public int[][] getFullPalette() {
        return this.fullPalette;
    }

    public String getColor(int place) {
        if (place >= 16 || place < 0) {
            System.out.println("Error getting color with slot data of: " + place);
            return "";
        }
        if (!this.colorUsed[place]) {
            return "null";
        }
        return this.intColorToHex(this.fullPalette[place]);
    }

    public int[][] getEvenColors(int palSpots, int[] baseCol, boolean light, boolean dark, boolean rndcha, boolean endDarkened) {
        return this.makeEvenColors(palSpots, baseCol, light, dark, rndcha, endDarkened);
    }

    public int[][] getOddColors(int palSpots, int[] baseCol, boolean light, boolean dark, boolean rndcha, boolean endDarkened) {
        return this.makeOddColors(palSpots, baseCol, light, dark, rndcha, endDarkened);
    }

    public void setLight(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Light slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        this.alLightDark.set(slot, 1);
    }

    public void setDark(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Dark slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        this.alLightDark.set(slot, 2);
    }

    public void setRandLight(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Light slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        this.alLightDark.set(slot, 3);
    }

    public void setRandDark(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Dark slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        this.alLightDark.set(slot, 4);
    }

    public void ensureNotLight(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        if (this.alLightDark.get(slot) == 1) {
            this.alLightDark.set(slot, 0);
        } else if (this.alLightDark.get(slot) == 3) {
            this.alLightDark.set(slot, 4);
        }
    }

    public void ensureNotDark(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        if (this.alLightDark.get(slot) == 2) {
            this.alLightDark.set(slot, 0);
        } else if (this.alLightDark.get(slot) == 4) {
            this.alLightDark.set(slot, 3);
        }
    }

    public void ensureBase(int slot) {
        if (slot >= this.alLightDark.size()) {
            System.out.println(" >< ERROR! Slot of " + slot + " does not exist! Max size is: " + this.alLightDark.size());
            return;
        }
        this.alLightDark.set(slot, 0);
    }

    public void resetColors() {
        this.alBaseColors = new ArrayList();
        this.alColorList = this.makeColorList();
        this.alLightDark = new ArrayList();
        this.resetColorsFamily();
    }

    public void resetColorsFamily() {
        this.fullPalette = new int[16][3];
        for (int i = 0; i < this.colorUsed.length; ++i) {
            this.colorUsed[i] = false;
        }
    }

    public void addRandomColorToBase() {
        int baseCol = this.alColorList.remove(this.rand.nextInt(this.alColorList.size()));
        this.alBaseColors.add(this.randBaseColor(this.baseColors[baseCol]));
        if (this.rand.nextInt(100) <= 20) {
            if (this.rand.nextInt(2) == 0) {
                this.alLightDark.add(4);
            } else {
                this.alLightDark.add(3);
            }
        } else {
            this.alLightDark.add(0);
        }
    }

    public void addTypeColorToBase(int type) {
        int cycles;
        int[] typeChoices = new int[]{type * 3, type * 3 + 1, type * 3 + 2};
        int baseCol = this.rand.nextInt(3);
        for (cycles = 0; !this.alColorList.contains(typeChoices[baseCol % 3]) && cycles < 3; ++cycles) {
            baseCol = (baseCol + 1) % 3;
        }
        if (cycles >= 3) {
            // empty if block
        }
        baseCol = this.alColorList.remove(baseCol);
        this.alBaseColors.add(this.randBaseColor(this.baseColors[baseCol]));
        if (this.rand.nextInt(100) <= 20) {
            if (this.rand.nextInt(2) == 0) {
                this.alLightDark.add(4);
            } else {
                this.alLightDark.add(3);
            }
        } else {
            this.alLightDark.add(0);
        }
    }

    public void addTypeColorToBase(int type, int type2) {
        int cycles;
        int[] typeChoices = new int[]{type * 3, type * 3 + 1, type * 3 + 2};
        int[] type2Choices = new int[]{type2 * 3, type2 * 3 + 1, type2 * 3 + 2};
        int baseCol = this.rand.nextInt(3);
        for (cycles = 0; !this.alColorList.contains(typeChoices[baseCol % 3]) && cycles < 3; ++cycles) {
            baseCol = (baseCol + 1) % 3;
        }
        if (cycles >= 3) {
            baseCol = this.rand.nextInt(3);
            for (cycles = 0; !this.alColorList.contains(type2Choices[baseCol % 3]) && cycles < 3; ++cycles) {
                baseCol = (baseCol + 1) % 3;
            }
            baseCol = cycles >= 3 ? this.alColorList.remove(this.rand.nextInt(this.alColorList.size())).intValue() : this.alColorList.remove(this.alColorList.indexOf(type2Choices[baseCol])).intValue();
        } else {
            baseCol = this.alColorList.remove(this.alColorList.indexOf(typeChoices[baseCol]));
        }
        this.alBaseColors.add(this.randBaseColor(this.baseColors[baseCol]));
        if (this.rand.nextInt(100) <= 20) {
            if (this.rand.nextInt(2) == 0) {
                this.alLightDark.add(4);
            } else {
                this.alLightDark.add(3);
            }
        } else {
            this.alLightDark.add(0);
        }
    }

    public void fillBaseColorsByType(int colorTotal, int type1, int type2) {
        while (this.alBaseColors.size() < colorTotal) {
            if (this.alBaseColors.size() == 0) {
                this.addTypeColorToBase(type1, type2);
                continue;
            }
            if (this.alBaseColors.size() == 1) {
                this.addTypeColorToBase(type2, type1);
                continue;
            }
            if (this.rand.nextInt(2) == 1) {
                this.addTypeColorToBase(type1, type2);
                continue;
            }
            this.addTypeColorToBase(type2, type1);
        }
    }

    public void fillBaseColors(int colorTotal) {
        while (this.alBaseColors.size() < colorTotal) {
            this.addRandomColorToBase();
        }
    }

    private void makeNewColorUsed() {
        this.colorUsed = new boolean[16];
        for (int i = 0; i < 16; ++i) {
            this.colorUsed[i] = false;
        }
    }

    private ArrayList<Integer> makeColorList() {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (int i = 0; i < this.baseColors.length; ++i) {
            out.add(i);
        }
        return out;
    }

    public void fillPaletteSlots(String info, int colorPtr, boolean endDarkened) {
        boolean rndcha;
        boolean dark;
        boolean light;
        if (this.alBaseColors.size() < colorPtr + 1 || this.alLightDark.size() < colorPtr + 1) {
            System.out.println(" XXXXXXXX  - Not enough color data to fill palette slots!");
            return;
        }
        switch (this.alLightDark.get(colorPtr)) {
            case 2: {
                light = false;
                dark = true;
                rndcha = false;
                break;
            }
            case 1: {
                light = true;
                dark = false;
                rndcha = false;
                break;
            }
            case 3: {
                light = false;
                dark = true;
                rndcha = true;
                break;
            }
            case 4: {
                light = true;
                dark = false;
                rndcha = true;
                break;
            }
            default: {
                light = false;
                dark = false;
                rndcha = false;
            }
        }
        String[] parts = info.split(",");
        int[][] shades = parts.length % 2 == 0 ? this.makeEvenColors(parts.length, this.alBaseColors.get(colorPtr), light, dark, rndcha, endDarkened) : this.makeOddColors(parts.length, this.alBaseColors.get(colorPtr), light, dark, rndcha, endDarkened);
        for (int i = 0; i < parts.length; ++i) {
            int slot = 0;
            try {
                slot = Integer.parseInt(parts[i]) - 1;
                this.colorUsed[slot] = true;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Could not parse color slot info into number: " + parts[i]);
            }
            for (int j = 0; j < 3; ++j) {
                this.fullPalette[slot][j] = shades[i][j];
            }
        }
    }

    public void fillPaletteSlotsSibling(String info1, String info2, int sharedColor, int colorPtr, boolean endDarkened) {
        int m;
        boolean rndcha;
        boolean dark;
        boolean light;
        if (this.alBaseColors.size() < colorPtr + 1 || this.alLightDark.size() < colorPtr + 1) {
            System.out.println("Not enough color data to fill palette slots!");
            return;
        }
        int[] baseCol = this.alBaseColors.get(colorPtr);
        switch (this.alLightDark.get(colorPtr)) {
            case 2: {
                light = false;
                dark = true;
                rndcha = false;
                break;
            }
            case 1: {
                light = true;
                dark = false;
                rndcha = false;
                break;
            }
            case 4: {
                light = false;
                dark = true;
                rndcha = true;
                break;
            }
            case 3: {
                light = true;
                dark = false;
                rndcha = true;
                break;
            }
            default: {
                light = false;
                dark = false;
                rndcha = false;
            }
        }
        String[] parts = info1.split(",");
        int[][] shades = parts.length % 2 == 0 ? this.makeEvenColors(parts.length, baseCol, light, dark, rndcha, endDarkened) : this.makeOddColors(parts.length, baseCol, light, dark, rndcha, endDarkened);
        for (int i = 0; i < parts.length; ++i) {
            int slot = 0;
            try {
                slot = Integer.parseInt(parts[i]) - 1;
                this.colorUsed[slot] = true;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Could not parse color slot info into number: " + parts[i]);
            }
            for (int j = 0; j < 3; ++j) {
                this.fullPalette[slot][j] = shades[i][j];
            }
        }
        int[] shColAr = this.fullPalette[sharedColor - 1];
        if (shColAr[0] <= 3 && shColAr[1] <= 3 && shColAr[2] <= 3) {
            for (m = 0; m < 3; ++m) {
                shColAr[m] = (int)((double)baseCol[m] * 0.15);
            }
        } else if (shColAr[0] >= 252 && shColAr[1] >= 252 && shColAr[2] >= 252) {
            for (m = 0; m < 3; ++m) {
                shColAr[m] = (int)((double)baseCol[m] * 0.85);
            }
        }
        shades = this.makeSiblingPalette(shColAr, info2, sharedColor);
        parts = info2.split(",");
        for (int i = 0; i < parts.length; ++i) {
            int slot = 0;
            try {
                slot = Integer.parseInt(parts[i]) - 1;
                this.colorUsed[slot] = true;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Could not parse color slot info into number: " + parts[i]);
            }
            for (int j = 0; j < 3; ++j) {
                this.fullPalette[slot][j] = shades[i][j];
            }
        }
    }

    private int[][] makeSiblingPalette(int[] sharedCol, String colData, int shared) {
        int p;
        int ptr;
        int p2;
        Object[] places = colData.split(",");
        int sharedLoc = this.indexOf(places, shared + "");
        if (sharedLoc == -1) {
            System.out.println("Error finding shared color in sibling palette.\n\t" + colData);
            return null;
        }
        int[][] out = new int[places.length][3];
        double[] variation = new double[]{(double)(this.rand.nextInt(10) + this.rand.nextInt(10) + this.rand.nextInt(10) + 3) * 0.01 * Math.pow(-1.0, this.rand.nextInt(2)), (double)(this.rand.nextInt(10) + this.rand.nextInt(10) + this.rand.nextInt(10) + 3) * 0.01 * Math.pow(-1.0, this.rand.nextInt(2)), (double)(this.rand.nextInt(10) + this.rand.nextInt(10) + this.rand.nextInt(10) + 3) * 0.01 * Math.pow(-1.0, this.rand.nextInt(2))};
        double[] leftShift = new double[]{this.getLeftColorChange(sharedLoc, sharedCol[0]), this.getLeftColorChange(sharedLoc, sharedCol[1]), this.getLeftColorChange(sharedLoc, sharedCol[2])};
        double[] rightShift = new double[]{this.getRightColorChange(places.length - sharedLoc - 1, sharedCol[0]), this.getRightColorChange(places.length - sharedLoc - 1, sharedCol[1]), this.getRightColorChange(places.length - sharedLoc - 1, sharedCol[2])};
        out[sharedLoc] = sharedCol;
        if (sharedLoc - 1 >= 0) {
            for (p2 = 0; p2 < 3; ++p2) {
                out[sharedLoc - 1][p2] = Math.min((int)((double)out[sharedLoc][p2] + leftShift[p2] * (1.0 + variation[p2])), 255);
            }
        }
        if (sharedLoc + 1 < out.length) {
            for (p2 = 0; p2 < 3; ++p2) {
                out[sharedLoc + 1][p2] = Math.max((int)((double)out[sharedLoc][p2] - rightShift[p2] * (1.0 + variation[p2])), 0);
            }
        }
        for (ptr = sharedLoc - 2; ptr >= 0; --ptr) {
            for (p = 0; p < 3; ++p) {
                out[ptr][p] = Math.min((int)((double)out[ptr + 1][p] + leftShift[p]), 255);
            }
        }
        for (ptr = sharedLoc + 2; ptr < out.length; ++ptr) {
            for (p = 0; p < 3; ++p) {
                out[ptr][p] = Math.max((int)((double)out[ptr - 1][p] - rightShift[p]), 0);
            }
        }
        return out;
    }

    private int[] randBaseColor(int[] baseColor) {
        int i;
        int[] outColor = new int[3];
        if (baseColor.length != 3) {
            System.out.println("RGB values need all 3 values to make a color!");
            return null;
        }
        for (i = 0; i < 3; ++i) {
            if (baseColor[i] <= 255) continue;
            System.out.println("Wrong color data, dummy! Max is 255!");
        }
        for (i = 0; i < 3; ++i) {
            int randMin = (int)(-0.032 * (double)baseColor[i] + 7.1);
            int randMax = (int)(-0.042 * (double)baseColor[i] + 17.19);
            int change = this.rand.nextInt(randMax - randMin) + this.rand.nextInt(randMax);
            outColor[i] = Math.min(baseColor[i] + (int)((double)(baseColor[i] * change) * 0.01 * Math.pow(-1.0, this.rand.nextInt(2))), 255);
        }
        return outColor;
    }

    private double getLeftColorChange(int palLimit, int maxRGB) {
        if (palLimit == 0) {
            return 0.0;
        }
        double coeff = (this.rand.nextInt(5) + this.rand.nextInt(5) + this.rand.nextInt(5) + 153) / palLimit;
        return coeff - coeff / 255.0 * (double)maxRGB + (double)(palLimit * palLimit);
    }

    private double getRightColorChange(int palLimit, int maxRGB) {
        if (palLimit == 0) {
            return 0.0;
        }
        double coeff = (this.rand.nextInt(5) + this.rand.nextInt(5) + this.rand.nextInt(5) + 153) / palLimit;
        return coeff - coeff / 255.0 * (double)(255 - maxRGB) + (double)(palLimit * palLimit);
    }

    private int[][] makeEvenColors(int palSpots, int[] baseCol, boolean light, boolean dark, boolean rndcha, boolean endDarkened) {
        int p;
        int ptr;
        int p2;
        int[][] out = new int[palSpots][3];
        int[] baseColor = new int[]{baseCol[0], baseCol[1], baseCol[2]};
        double[] leftShift = new double[]{this.getLeftColorChange(palSpots / 2, baseCol[0]), this.getLeftColorChange(palSpots / 2, baseCol[1]), this.getLeftColorChange(palSpots / 2, baseCol[2])};
        double[] rightShift = new double[]{this.getRightColorChange(palSpots / 2, baseCol[0]), this.getRightColorChange(palSpots / 2, baseCol[1]), this.getRightColorChange(palSpots / 2, baseCol[2])};
        if (light || dark) {
            int i;
            double mod;
            if (dark) {
                mod = rndcha ? 0.2 : 0.5;
                for (i = 0; i < 3; ++i) {
                    baseColor[i] = Math.max((int)((double)baseColor[i] - rightShift[i] * (double)(palSpots / 2 + 1) * mod), 0);
                }
                leftShift[0] = this.getRightColorChange(palSpots / 2, baseColor[0]);
                leftShift[1] = this.getRightColorChange(palSpots / 2, baseColor[1]);
                leftShift[2] = this.getRightColorChange(palSpots / 2, baseColor[2]);
                rightShift[0] = this.getRightColorChange(palSpots / 2, baseColor[0]);
                rightShift[1] = this.getRightColorChange(palSpots / 2, baseColor[1]);
                rightShift[2] = this.getRightColorChange(palSpots / 2, baseColor[2]);
            } else {
                mod = 0.5;
                mod = rndcha ? 0.2 : 0.5;
                for (i = 0; i < 3; ++i) {
                    baseColor[i] = Math.min((int)((double)baseColor[i] + leftShift[i] * (double)(palSpots / 2 + 1) * mod), 255);
                }
                leftShift[0] = this.getLeftColorChange(palSpots / 2, baseColor[0]);
                leftShift[1] = this.getLeftColorChange(palSpots / 2, baseColor[1]);
                leftShift[2] = this.getLeftColorChange(palSpots / 2, baseColor[2]);
                rightShift[0] = this.getLeftColorChange(palSpots / 2, baseColor[0]);
                rightShift[1] = this.getLeftColorChange(palSpots / 2, baseColor[1]);
                rightShift[2] = this.getLeftColorChange(palSpots / 2, baseColor[2]);
                mod = this.lightDarkenCoeff(baseCol);
                for (int k = 0; k < rightShift.length; ++k) {
                    int n = k;
                    rightShift[n] = rightShift[n] + mod * this.getLeftColorChange(palSpots / 2, baseColor[k]);
                }
            }
        }
        int totalChange = 0;
        for (int r = 0; totalChange < 9 && r < 5; ++r) {
            totalChange = 0;
            for (p2 = 0; p2 < 3; ++p2) {
                out[out.length / 2 - 1][p2] = Math.min((int)((double)baseColor[p2] + leftShift[p2] * 0.5), 255);
                out[out.length / 2][p2] = Math.max((int)((double)baseColor[p2] - rightShift[p2] * 0.5), 0);
                totalChange += (out[out.length / 2][p2] >> 2) - (out[out.length / 2 - 1][p2] >> 2);
            }
        }
        for (ptr = out.length / 2 - 2; ptr >= 0; --ptr) {
            for (p = 0; p < 3; ++p) {
                out[ptr][p] = Math.min((int)((double)out[ptr + 1][p] + leftShift[p]), 255);
            }
        }
        for (ptr = out.length / 2 + 1; ptr < out.length; ++ptr) {
            for (p = 0; p < 3; ++p) {
                out[ptr][p] = Math.max((int)((double)out[ptr - 1][p] - rightShift[p]), 0);
            }
        }
        if (endDarkened) {
            ptr = out.length - 1;
            for (int j = 0; j < 1; ++j) {
                for (p2 = 0; p2 < 3; ++p2) {
                    out[ptr][p2] = Math.max((int)((double)out[ptr][p2] - rightShift[p2]), 0);
                }
            }
        }
        return out;
    }

    private double lightDarkenCoeff(int[] baseCol) {
        int[] bc = (int[])baseCol.clone();
        Arrays.sort(bc);
        double avg = (double)(bc[1] + bc[2]) / 2.0;
        if (baseCol[1] >= 225 && baseCol[0] < 200 && baseCol[2] < 200) {
            avg += 75.0;
        }
        if (baseCol[1] >= 225) {
            avg += 75.0;
        }
        if (avg > 255.0) {
            avg = 255.0;
        }
        if (avg < 192.0) {
            return 0.5;
        }
        return (2.0E-4 * Math.pow(avg - 192.0, 3.5) + 50.0) * 0.01;
    }

    private double lightenBaseCoeff(int[] baseCol) {
        int[] bc = (int[])baseCol.clone();
        Arrays.sort(bc);
        double avg = (double)(bc[1] + bc[2]) / 2.0;
        return 2.0E-16 * Math.pow(avg, 6.8) * 0.01;
    }

    private int[][] makeOddColors(int palSpots, int[] baseCol, boolean light, boolean dark, boolean rndcha, boolean endDarkened) {
        int p;
        int ptr;
        int[][] out = new int[palSpots][3];
        int[] baseColor = new int[]{baseCol[0], baseCol[1], baseCol[2]};
        double[] leftShift = new double[]{this.getLeftColorChange((palSpots - 1) / 2, baseColor[0]), this.getLeftColorChange((palSpots - 1) / 2, baseColor[1]), this.getLeftColorChange((palSpots - 1) / 2, baseColor[2])};
        double[] rightShift = new double[]{this.getRightColorChange((palSpots - 1) / 2, baseColor[0]), this.getRightColorChange((palSpots - 1) / 2, baseColor[1]), this.getRightColorChange((palSpots - 1) / 2, baseColor[2])};
        if (light || dark) {
            int i;
            double mod;
            if (dark) {
                mod = rndcha ? 0.2 : 0.5;
                for (i = 0; i < 3; ++i) {
                    baseColor[i] = Math.max((int)((double)baseColor[i] - rightShift[i] * (double)(palSpots / 2 + 1) * mod), 0);
                }
                leftShift[0] = this.getRightColorChange((palSpots - 1) / 2, baseColor[0]);
                leftShift[1] = this.getRightColorChange((palSpots - 1) / 2, baseColor[1]);
                leftShift[2] = this.getRightColorChange((palSpots - 1) / 2, baseColor[2]);
                rightShift[0] = this.getRightColorChange((palSpots - 1) / 2, baseColor[0]);
                rightShift[1] = this.getRightColorChange((palSpots - 1) / 2, baseColor[1]);
                rightShift[2] = this.getRightColorChange((palSpots - 1) / 2, baseColor[2]);
            } else {
                mod = rndcha ? 0.2 : 0.5;
                for (i = 0; i < 3; ++i) {
                    baseColor[i] = Math.min((int)((double)baseColor[i] + leftShift[i] * (double)(palSpots / 2 + 1) * mod), 255);
                }
                leftShift[0] = this.getLeftColorChange((palSpots - 1) / 2, baseColor[0]);
                leftShift[1] = this.getLeftColorChange((palSpots - 1) / 2, baseColor[1]);
                leftShift[2] = this.getLeftColorChange((palSpots - 1) / 2, baseColor[2]);
                rightShift[0] = this.getLeftColorChange((palSpots - 1) / 2, baseColor[0]);
                rightShift[1] = this.getLeftColorChange((palSpots - 1) / 2, baseColor[1]);
                rightShift[2] = this.getLeftColorChange((palSpots - 1) / 2, baseColor[2]);
                mod = this.lightDarkenCoeff(baseCol);
                for (int k = 0; k < rightShift.length; ++k) {
                    int n = k;
                    rightShift[n] = rightShift[n] + mod * this.getLeftColorChange(palSpots / 2, baseColor[k]);
                }
            }
        }
        try {
            out[out.length / 2] = baseColor;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (out.length != 1) {
                System.out.println("Error with odd palette middle slot array index");
            }
            out[0] = baseColor;
            return out;
        }
        for (ptr = out.length / 2 - 1; ptr >= 0; --ptr) {
            for (p = 0; p < 3; ++p) {
                out[ptr][p] = Math.min((int)((double)out[ptr + 1][p] + leftShift[p]), 255);
            }
        }
        for (ptr = out.length / 2 + 1; ptr < out.length; ++ptr) {
            for (p = 0; p < 3; ++p) {
                out[ptr][p] = Math.max((int)((double)out[ptr - 1][p] - rightShift[p]), 0);
            }
        }
        if (endDarkened) {
            ptr = out.length - 1;
            for (int j = 0; j < 1; ++j) {
                for (int p2 = 0; p2 < 3; ++p2) {
                    out[ptr][p2] = Math.max((int)((double)out[ptr][p2] - rightShift[p2]), 0);
                }
            }
        }
        return out;
    }

    private String intColorToHex(int[] col) {
        if (col.length != 3) {
            System.out.println("Color to Hex error!");
            return "";
        }
        int color = (col[2] >> 3 << 10) + (col[1] >> 3 << 5) + (col[0] >> 3);
        String out = this.intToHex(color, 4);
        return out.substring(2) + out.substring(0, 2);
    }

    public void print() {
        for (int k = 0; k < this.fullPalette.length; ++k) {
            if (this.colorUsed[k]) {
                System.out.print(this.intColorToHex(this.fullPalette[k]) + " ");
                continue;
            }
            System.out.print("---- ");
        }
        System.out.println("");
    }

    public void printColorUsed() {
        for (int i = 0; i < this.colorUsed.length; ++i) {
            System.out.print(this.colorUsed[i] + " ");
        }
        System.out.println("");
    }

    private int indexOf(Object[] ar, Object src) {
        for (int i = 0; i < ar.length; ++i) {
            if (!ar[i].equals(src)) continue;
            return i;
        }
        return -1;
    }

    private int indexOf(int[] ar, int src) {
        for (int i = 0; i < ar.length; ++i) {
            if (ar[i] != src) continue;
            return i;
        }
        return -1;
    }

    private String intToHex(int n, int size) {
        StringBuffer out = new StringBuffer(Integer.toHexString(n));
        for (int i = size - out.length(); i > 0; --i) {
            out.insert(0, "0");
        }
        if (out.length() > size) {
            System.out.println("intToHex error: int " + n + " too big for size " + size);
            return out.toString().substring(out.length() - size);
        }
        return out.toString();
    }
}

