/*
 * Decompiled with CFR 0.152.
 */
package emeraldrandomizer;

import emeraldrandomizer.ArrayKeeper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PokeData {
    private int[] stats = new int[]{1, 1, 1, 1, 1, 1};
    private int[] types = new int[]{0, 0};
    private int[] evs = new int[]{0, 0, 0, 0, 0, 0};
    private int[] abilities = new int[]{1, 0};
    private int[] heldItems = new int[]{0, 0};
    private int[] statSwaps = new int[]{0, 1, 2, 3, 4, 5};
    private int[] TMcompat = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int[] tutorCompat = new int[]{0, 0, 0, 0};
    private HashMap<Integer, Integer> attackHash;
    private ArrayList<Integer> availableMoves;
    private final int HELD_ITEM_CHANCE = 25;
    private final int DUAL_TYPE_CHANCE = 47;
    private final int ADD_DUAL_TYPE_CHANCE = 21;
    private final int DUAL_ABILITY_CHANCE = 50;

    public PokeData() {
    }

    public PokeData(int[] data) {
        if (data.length < 28) {
            System.out.println("Error parsing Pokemon Data: Expected 28 bytes, got " + data.length);
        } else {
            for (int i = 0; i < 6; ++i) {
                this.setStat(i, data[i]);
                this.evs[i] = data[10 + i / 4] >> i * 2 % 8 & 3;
            }
            this.setType(0, data[6]);
            this.setType(1, data[7]);
            this.setAbility(0, data[22]);
            this.setAbility(1, data[23]);
            this.heldItems = new int[]{data[13] * 256 + data[12], data[15] * 256 + data[14]};
        }
    }

    private boolean isValidMatrix(int expectedSize, int actualSize, String matrix) {
        if (actualSize < expectedSize) {
            System.out.println("Invalid PokeData " + matrix + " allocation: Expected " + expectedSize + "-byte matrix, found len " + actualSize);
            return false;
        }
        return true;
    }

    public void setHP(int i) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(0, i);
    }

    public void setAT(int i) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(1, i);
    }

    public void setDF(int i) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(2, i);
    }

    public void setSA(int i) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(4, i);
    }

    public void setSD(int i) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(5, i);
    }

    public void setSP(int i) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(3, i);
    }

    private void setStat(int place, int value) {
        this.stats[place] = value <= 0 ? 1 : (value > 255 ? 255 : value);
    }

    public void setStats(int hp, int at, int df, int sa, int sd, int sp) {
        if (!this.isValidMatrix(6, this.stats.length, "stats")) {
            return;
        }
        this.setStat(0, hp);
        this.setStat(1, at);
        this.setStat(2, df);
        this.setStat(3, sp);
        this.setStat(4, sa);
        this.setStat(5, sd);
    }

    public void setType(int typeSlot, int i) {
        if (!this.isValidMatrix(2, this.types.length, "types")) {
            return;
        }
        if (typeSlot > 1 || typeSlot < 0) {
            System.out.println("Invalid type slot: " + typeSlot + " -- type change ignored.");
            return;
        }
        if (i < 0 || i > 17 || i == 9) {
            System.out.println("Invalid type ignored: " + i + " -- set to Normal-type (0x00)");
            this.types[typeSlot] = 0;
        } else {
            this.types[typeSlot] = i;
        }
    }

    public void setTypes(int i, int j) {
        if (!this.isValidMatrix(2, this.types.length, "types")) {
            return;
        }
        this.setType(0, i);
        this.setType(1, j);
    }

    public void setEVs(int hp, int at, int df, int sa, int sd, int sp) {
        this.setEVs(new int[]{hp, at, df, sa, sd, sp});
    }

    public void setEVs(int[] evIn) {
        if (!this.isValidMatrix(6, this.evs.length, "EVs")) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            if (evIn[i] < 0 || evIn[i] > 3) {
                System.out.println("  > Erroneous EV value: " + evIn[i] + " -- 0 used instead.");
                this.evs[i] = 0;
                continue;
            }
            this.evs[i] = evIn[i];
        }
    }

    public void setAbilities(int abil1, int abil2) {
        if (!this.isValidMatrix(2, this.abilities.length, "abilities")) {
            return;
        }
        this.setAbility(0, abil1);
        this.setAbility(1, abil2);
    }

    public void setAbility(int abilitySlot, int abil) {
        if (!this.isValidMatrix(2, this.abilities.length, "abilities")) {
            return;
        }
        if (abilitySlot > 1 || abilitySlot < 0) {
            System.out.println("Erroneous ability slot: " + abilitySlot + " -- ability change ignored.");
            return;
        }
        if (abil < 0 || abil > 77) {
            System.out.println("  > Erroneous ability value: " + abil + " -- ability 01 (Stench) used instead.");
            this.abilities[abilitySlot] = 1;
        } else if (abilitySlot == 0 && abil == 0) {
            System.out.println("  > Ability 1 cannot be 0 -- ability 01 (Stench) used instead.");
            this.abilities[abilitySlot] = 1;
        } else {
            this.abilities[abilitySlot] = abil;
        }
    }

    public void setHeldItem(int slot, int item) {
        if (!this.isValidMatrix(2, this.heldItems.length, "held items")) {
            return;
        }
        if (slot > 1 || slot < 0) {
            System.out.println("Erroneous held item slot: " + slot + " -- held item change ignored.");
            return;
        }
        this.heldItems[slot] = item < 0 ? 0 : (item > 346 ? 346 : item);
    }

    public void setHeldItems(int item1, int item2) {
        this.setHeldItem(0, item1);
        this.setHeldItem(1, item2);
    }

    public void setStatSwaps(int a, int b, int c, int d, int e, int f) {
        this.setStatSwaps(new int[]{a, b, c, d, e, f});
    }

    public void setStatSwaps(int[] swaps) {
        int i;
        if (swaps.length != 6 || this.statSwaps.length != 6) {
            System.out.println("Error with stat swap array lengths. No stats swap data was retained.");
            return;
        }
        for (i = 0; i < this.statSwaps.length; ++i) {
            if (swaps[i] <= 5 && swaps[i] >= 0) continue;
            System.out.println("Error with stat swap pointers. No stats swap data was retained.");
            return;
        }
        for (i = 0; i < this.statSwaps.length; ++i) {
            this.statSwaps[i] = swaps[i];
        }
    }

    public void setTMCompatability(int[] inp) {
        if (!this.isValidMatrix(8, this.TMcompat.length, "TM compatability")) {
            return;
        }
        for (int i = 0; i < this.TMcompat.length; ++i) {
            this.TMcompat[i] = inp[i];
        }
    }

    public void setTutorCompatability(int[] inp) {
        if (!this.isValidMatrix(4, this.tutorCompat.length, "Move Tutor compatability")) {
            return;
        }
        for (int i = 0; i < this.tutorCompat.length; ++i) {
            this.tutorCompat[i] = inp[i];
        }
    }

    public void setAttackHash(HashMap<Integer, Integer> atkHash) {
        this.attackHash = atkHash;
    }

    public void setAvailableMoves(ArrayList<Integer> movelist) {
        this.availableMoves = movelist;
    }

    public int[] getStats() {
        return this.stats;
    }

    public int getStat(int slot) {
        if (slot > 5 || slot < 0) {
            return 1;
        }
        return this.stats[slot];
    }

    public int[] getTypes() {
        return this.types;
    }

    public int getType(int slot) {
        if (slot > 1 || slot < 0) {
            return 0;
        }
        return this.types[slot];
    }

    public int[] getEVs() {
        return this.evs;
    }

    public int getEV(int slot) {
        if (slot > 5 || slot < 0) {
            return 0;
        }
        return this.evs[slot];
    }

    public int[] getAbilities() {
        return this.abilities;
    }

    public int getAbility(int slot) {
        if (slot > 1 || slot < 0) {
            return 0;
        }
        return this.abilities[slot];
    }

    public int[] getItems() {
        return this.heldItems;
    }

    public int getItem(int slot) {
        if (slot > 1 || slot < 0) {
            return 0;
        }
        return this.heldItems[slot];
    }

    public int[] getStatSwaps() {
        return this.statSwaps;
    }

    public int[] getTMCompatability() {
        return this.TMcompat;
    }

    public int[] getTutorCompatability() {
        return this.tutorCompat;
    }

    public ArrayList<Integer> getAvailableMoves() {
        return this.availableMoves;
    }

    public HashMap<Integer, Integer> getAttackHash() {
        return this.attackHash;
    }

    public void swapStats() {
        int i;
        if (this.stats.length != 6 || this.statSwaps.length != 6 || this.evs.length != 6) {
            System.out.println("Error with stat swap array lengths. No stats were swapped.");
            return;
        }
        int[] statBak = new int[this.stats.length];
        int[] evsBak = new int[this.evs.length];
        for (i = 0; i < this.stats.length; ++i) {
            statBak[i] = this.stats[i];
            evsBak[i] = this.evs[i];
        }
        for (i = 0; i < this.stats.length; ++i) {
            this.stats[i] = statBak[this.statSwaps[i]];
            this.evs[i] = evsBak[this.statSwaps[i]];
        }
    }

    public void swapStats(int[] swaps) {
        this.setStatSwaps(swaps);
        this.swapStats();
    }

    public void randomizeStats() {
        int[] statsBak = (int[])this.stats.clone();
        int[] evBak = (int[])this.evs.clone();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        Random rand = new Random();
        for (int i = 0; i < 6; ++i) {
            slots.add(i);
        }
        for (int i = 0; i < 6; ++i) {
            int randChox = (Integer)slots.remove(rand.nextInt(slots.size()));
            this.stats[i] = statsBak[randChox];
            this.evs[i] = evBak[randChox];
            this.statSwaps[i] = randChox;
        }
    }

    public void randomizeAbilities() {
        Random rand = new Random();
        ArrayList<Integer> alAbil = this.getAbilityList();
        this.abilities[0] = alAbil.remove(rand.nextInt(alAbil.size()));
        this.abilities[1] = rand.nextInt(100) < 50 ? alAbil.remove(rand.nextInt(alAbil.size())) : this.abilities[0];
    }

    public void randomizeTypes() {
        int baseType;
        Random rand = new Random();
        ArrayList<Integer> alTypes = this.getTypeList();
        this.types[0] = baseType = alTypes.remove(rand.nextInt(alTypes.size())).intValue();
        this.types[1] = rand.nextInt(100) < 47 ? alTypes.remove(rand.nextInt(alTypes.size())) : baseType;
    }

    public void randomizeType(int typeSlot) {
        Random rand = new Random();
        ArrayList<Integer> alTypes = this.getTypeList();
        if (rand.nextInt(100) <= 21) {
            this.types[typeSlot] = alTypes.remove(rand.nextInt(alTypes.size()));
        }
    }

    public void rerandomizeTypes() {
        if (this.types.length != 2) {
            this.types = new int[]{0, 0};
            System.out.println(" !! Types array re-cast to allow 2 slots.");
        }
        if (this.types[0] == this.types[1]) {
            Random rand = new Random();
            ArrayList<Integer> alTypes = this.getTypeList();
            if (rand.nextInt(100) <= 21) {
                this.types[1] = alTypes.remove(rand.nextInt(alTypes.size()));
            }
        }
    }

    public void derandomizeTypes() {
        Random rand;
        if (this.types.length != 2) {
            this.types = new int[]{0, 0};
            System.out.println(" !! Types array re-cast to allow 2 slots.");
        }
        if (this.types[0] != this.types[1] && (rand = new Random()).nextInt(100) <= 21) {
            this.types[1] = this.types[0];
        }
    }

    public void randomizeItems() {
        ArrayKeeper ak = new ArrayKeeper();
        ArrayList<Integer> alItems = ak.getArrayListInt(ak.getUsableItems());
        Random rand = new Random();
        for (int i = 0; i < 2; ++i) {
            this.heldItems[i] = rand.nextInt(100) < 25 ? alItems.remove(rand.nextInt(alItems.size())) : 0;
        }
    }

    public void rerandomizeItems() {
        ArrayKeeper ak = new ArrayKeeper();
        ArrayList<Integer> alItems = ak.getArrayListInt(ak.getUsableItems());
        Random rand = new Random();
        for (int i = 0; i < 2; ++i) {
            if (this.heldItems[i] != 0 || rand.nextInt(100) >= 25) continue;
            this.heldItems[i] = alItems.remove(rand.nextInt(alItems.size()));
        }
    }

    public void derandomizeItems() {
        Random rand = new Random();
        for (int i = 0; i < 2; ++i) {
            if (this.heldItems[i] == 0 || rand.nextInt(100) >= 25) continue;
            this.heldItems[i] = 0;
        }
    }

    public void randomizeTMCompatability() {
        Random rand = new Random();
        for (int i = 0; i < this.TMcompat.length; ++i) {
            this.TMcompat[i] = rand.nextInt(256);
        }
    }

    public void rerandomizeTMCompatability() {
        Random rand = new Random();
        for (int i = 0; i < this.TMcompat.length; ++i) {
            this.TMcompat[i] = this.TMcompat[i] | rand.nextInt(256) & rand.nextInt(256) & rand.nextInt(256);
        }
    }

    public void derandomizeTMCompatability() {
        Random rand = new Random();
        for (int i = 0; i < this.TMcompat.length; ++i) {
            this.TMcompat[i] = this.TMcompat[i] & (~(rand.nextInt(256) & rand.nextInt(256) & rand.nextInt(256)) & 0xFF);
        }
    }

    public void randomizeTutorCompatability() {
        Random rand = new Random();
        for (int i = 0; i < this.tutorCompat.length; ++i) {
            this.tutorCompat[i] = rand.nextInt(256);
        }
    }

    public void rerandomizeTutorCompatability() {
        Random rand = new Random();
        for (int i = 0; i < this.tutorCompat.length; ++i) {
            this.tutorCompat[i] = this.tutorCompat[i] | rand.nextInt(256) & rand.nextInt(256);
        }
    }

    public void derandomizeTutorCompatability() {
        Random rand = new Random();
        for (int i = 0; i < this.tutorCompat.length; ++i) {
            this.tutorCompat[i] = this.tutorCompat[i] & (~(rand.nextInt(256) & rand.nextInt(256)) & 0xFF);
        }
    }

    public ArrayList<Integer> getAbilityList() {
        ArrayList<Integer> alOut = new ArrayList<Integer>();
        for (int i = 1; i <= 76; ++i) {
            alOut.add(i);
        }
        alOut.remove(new Integer(25));
        alOut.remove(new Integer(59));
        return alOut;
    }

    public ArrayList<Integer> getTypeList() {
        ArrayList<Integer> alOut = new ArrayList<Integer>();
        for (int i = 0; i <= 17; ++i) {
            alOut.add(i);
        }
        alOut.remove(9);
        return alOut;
    }

    public String toString() {
        int i;
        ArrayKeeper lk = new ArrayKeeper();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 6; ++i) {
            if (this.stats[i] < 10) {
                sb.append("  ");
            } else if (this.stats[i] < 100) {
                sb.append(" ");
            }
            sb.append(this.stats[i] + " ");
        }
        sb.append("  |  ");
        for (i = 0; i < 6; ++i) {
            if (this.evs[i] == 0) {
                sb.append("- ");
                continue;
            }
            sb.append(this.evs[i] + " ");
        }
        sb.append("  | ");
        String[] typeList = lk.getTypeList();
        sb.append(typeList[this.types[0]]);
        if (this.types[0] == this.types[1]) {
            sb.append("     |  ");
        } else {
            sb.append("/" + typeList[this.types[1]] + " |  ");
        }
        String[] abilityList = lk.getAbilityList();
        for (int j = 0; j < 2; ++j) {
            String abil = abilityList[this.abilities[j]];
            sb.append(abil);
            for (int i2 = abil.length(); i2 <= 12; ++i2) {
                sb.append(" ");
            }
            sb.append(" | ");
        }
        String[] itemList = lk.getItemList();
        for (int j = 0; j < 2; ++j) {
            String item = itemList[this.heldItems[j]];
            sb.append(item);
            for (int i3 = item.length(); i3 <= 12; ++i3) {
                sb.append(" ");
            }
            sb.append(" | ");
        }
        return sb.toString();
    }

    public PokeData getClone() {
        PokeData out = new PokeData();
        out.setStats(this.stats[0], this.stats[1], this.stats[2], this.stats[3], this.stats[4], this.stats[5]);
        out.setEVs(this.evs);
        out.setAbilities(this.abilities[0], this.abilities[1]);
        out.setStatSwaps(this.statSwaps);
        out.setTypes(this.types[0], this.types[1]);
        out.setHeldItems(this.heldItems[0], this.heldItems[1]);
        out.setTMCompatability(this.TMcompat);
        out.setAvailableMoves(this.availableMoves);
        out.setAttackHash(this.attackHash);
        return out;
    }
}

